const hammer = document.querySelector('.hammer')
const holes = document.querySelectorAll('.hole')
const content = document.querySelector('.content')

const scoreBoard = document.querySelector('.score')
const speedBoard = document.querySelector('.speed')
const timerBoard = document.querySelector('.timer')

const SCORE_ADDITION = 50

/// Mole
const MOLE = './assets/img/mole.png'
const MOLE_WACKED = './assets/img/mole-whacked.png'

/// Speed 
const SPEED_START = 1250
const SPEED_FASTER = 50
const SPEED_UPDATE = 100
const SPEED_MIN = 750

const SPEEDS = [
    { max: SPEED_START, txt: "SLOW" },  
    { max: SPEED_START - SPEED_UPDATE, txt: "MEDIUM" }, 
    { max: SPEED_START - (2 * SPEED_UPDATE), txt: "FAST" }, 
    { max: SPEED_START - (4 * SPEED_UPDATE), txt: "RIDICULOUS"}
]

let score = 0
let speed = SPEED_START
let time = 60

/// Hamer
window.addEventListener('mousemove', e => {
    hammer.style.top = e.pageY + 'px'
    hammer.style.left = e.pageX + 'px'
})

window.addEventListener('mousedown', () => {
    hammer.classList.add('active')
})

window.addEventListener('mouseup', () => {
    hammer.classList.remove('active')
})

/// Speed
const getSpeedText = (speed) => {
    let curSpeed = SPEEDS.filter( s => speed <= s.max)
    return(curSpeed[curSpeed.length - 1].txt)
} 


const setSpeed = () => {  
    if( score % SPEED_UPDATE === 0 && speed > SPEED_MIN) {
        speed -= SPEED_FASTER
        speedBoard.textContent = getSpeedText(speed)
    }
}

/// Score
const setScore = () => {
    score += SCORE_ADDITION
    scoreBoard.textContent = score
    setSpeed()
}


/// Countdown
const countDown = () => {
    time--
    timerBoard.textContent = `${ time }s`
   
    if (time == 0) {
      clearInterval(countDownTimerId)
      content.remove()
    }
   
}

/// Random Hole
const getRandomHole = () => {
    return( Math.floor(Math.random() * holes.length) )
}



/// Mole
const createMole = () => {
    const img = document.createElement('img')
    img.classList.add('mole')
    img.src = MOLE

    img.addEventListener('click', () => {
        setScore()
        img.src = MOLE_WACKED
    })

    return(img)
}

/// Game Engine
const main = () => {    
    const hole = holes[getRandomHole()]
    let timer = null
    const img = createMole()
    hole.appendChild(img)

    timer = setTimeout(() => {
        hole.removeChild(img)
        main()
    }, speed)
}

/// GO!
let countDownTimerId = setInterval(countDown, 1000)
main()